create or replace package body tbicds.PCK_FX_SEC_PATIENT is
  
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /* checks if a portal account exists for the patient */
   procedure CheckPatientFXUserRecRS( pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_vKey             in varchar2,
                                      pi_vPatientID       in varchar2,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select count(f.fx_user_id) as FXUserCount '
                || 'from tbicds.fx_user f '
                || 'where f.fx_user_id = ('
                || 'select p.fx_user_id '
                || 'from tbicds.patient_demographics p '
                || 'where p.patient_id = :P0 '
                || ') ';
      open rs for v_vSql using pi_vPatientID;
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := '182 - An error occurred while checking a patients account, Please contact your system administrator.';
   end;

   /* gets a FXUserID given the patient */
   procedure GetPatientFXUserIdRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vKey in varchar2,
                                  pi_vPatientID      in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select fx_user_id from tbicds.patient_demographics t where patient_id = :P0 ';
      open rs for v_vSql using pi_vPatientID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := '181 - An error occurred while retrieving a patients account, Please contact your system administrator.';
   end;

   /* gets the encrypted username/password pair for the patient */
   procedure GetPatientFXUsernamePasswordRS(pi_vSessionID       in varchar2,
                                            pi_vSessionClientIP in varchar2,
                                            pi_nUserID          in number,
                                            pi_vKey in varchar2,
                                            pi_vPatientID       in varchar2,
                                            po_nStatusCode      out number,
                                            po_vStatusComment   out varchar2,
                                            rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.fx_user t '
                || 'where fx_user_id = ('
                || 'select fx_user_id from tbicds.patient_demographics t where patient_id = :P0 '
                || ') ';
      open rs for v_vSql using pi_vPatientID;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := '180 - An error occurred while retrieving patients account information, Please contact your system administrator.';
   end;

   /* updates the patient portal account */
   procedure InsertPatientFXUser (pi_vSessionID              in varchar2,
                                  pi_vSessionClientIP        in varchar2,
                                  pi_nUserID                 in number,
                                  pi_vKey in varchar2,
                                  pi_vPatientID              in varchar2,
                                  pi_vUserName               in varchar2,
                                  pi_vPassword               in varchar2,
                                  pi_nAccountLocked          in number,
                                  pi_nAccountInactive        in number,
                                  pi_vCOldPassword           in varchar2,
                                  pi_vCPassword              in varchar2,
                                  pi_vCUserName              in varchar2,   
                                  po_nFXUserID               out number,
                                  po_nStatusCode             out number,
                                  po_vStatusComment          out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nCount            number;
      v_nFXUserID         number;
      dtSys               date;
      v_nUserType         number := 32768;
   begin
      --default status to good
      po_nStatusCode := 0; --0 = success
      po_vStatusComment := '';

      v_nCount := 0;
      v_nFXUserID := 0;
      dtSys := sysdate;

      --get a new user id from the sequence
      --
      v_vSql := 'select tbicds.seqFXUserID.Nextval from dual';
      execute immediate v_vSql into v_nFXUserID;

      v_vSql := 'insert into tbicds.fx_user ('
                || 'fx_user_id, user_name, is_locked, is_inactive, '
                || 'date_created, date_modified, updated_by, reset_password, date_password_changed, '
                || 'date_last_login, session_timeout, login_attempts, password, last_updated, '
                || 'last_updated_by) '
                || 'values ('
                || ':P0, :P1, :P2, :P3, :P4, :P5, :P6, :P7, :P8, :P9, '
                || ':P10, :P11, :P12, :P13, :P14, :P15) ';
      execute immediate v_vSql using
         v_nFXUserID,              --fx_user_id,
         pi_vUserName,             --user_name,
         pi_nAccountLocked,        --is_locked,
         pi_nAccountInactive,      --is_inactive,
         dtSys,                    --date_created,
         dtSys,                    --date_modified,
         pi_nUserID,               --updated_by,
         1,                        --ALWAYS MUST reset_password,
         dtSys,                    --date_password_changed,
         dtSys,                    --date_last_login,
         30,                       --session_timeout,
         0,                        --login_attempts,
         pi_vPassword,              --password
         sysdate,
         pi_nUserID;
      commit;
      
      v_vSql := 'insert into tbicds.fx_user_rights ('
                || 'fx_user_id, user_rights, read_only, user_type) '
                || 'values ('
                || ':P0, :P1, :P2, :P3) ';
      execute immediate v_vSql using v_nFXUserID, 0, 0, v_nUserType;
      commit;

      --update the app_user table fx id
      v_vSql := 'update tbicds.patient_demographics set '
                || 'fx_user_id = :P0, '
                || 'last_updated = sysdate, '
                || 'last_updated_by = :P1 '
                || 'where patient_id = :P2 ';
      execute immediate v_vSql using v_nFXUserID, pi_nUserID, pi_vPatientID;
      commit;
      
      --have to insert the record before validating
      pck_fx_sec.ValidatePassword(
                        pi_vKey,
                        v_nFXUserID,
                        pi_vUserName,
                        'NA',
                        pi_vPassword,
                        'NA',
                        pi_vCPassword,
                        pi_vCUserName,
                        1,
                        po_nStatusCode,
                        po_vStatusComment);
       
      if po_nStatusCode != 0 then
         --clear the fx record for the patient
         v_vSql := 'update tbicds.patient_demographics set fx_user_id = null where fx_user_id = :P0';
         execute immediate v_vSql using v_nFXUserID;
         
         --remove the fx_user from the db
         v_vSql := 'delete from tbicds.fx_user where fx_user_id = :P0';
         execute immediate v_vSql using v_nFXUserID;
         commit;
         
         v_vSql := 'delete from tbicds.fx_user_rights where fx_user_id = :P0';
         execute immediate v_vSql using v_nFXUserID;
         commit;
         
         po_nFXUserID := 0;
      end if;

      po_nFXUserID := v_nFXUserID;

   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := '177 - An error occurred while inserting a pateint user record, Please contact your system administrator.';
   end;

   /* updates the patient portal account password*/
   procedure UpdatePatientFXUserPWD(pi_vSessionID              in varchar2,
                                    pi_vSessionClientIP        in varchar2,
                                    pi_nUserID                 in number,
                                    pi_vKey in varchar2,
                                    pi_nFXUserID               in number,
                                    pi_vUserName               in varchar2,
                                    pi_vPassword               in varchar2,
                                    pi_nAccountLocked          in number,
                                    pi_nAccountInactive        in number,
                                    pi_vCPassword              in varchar2,
                                    pi_vCUserName              in varchar2,
                                    po_nStatusCode             out number,
                                    po_vStatusComment          out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nCount            number;
      dtSys               date;
      v_currpwd           varchar2(4000);
   begin
      --default status to good
      po_nStatusCode := 0; --0 = success
      po_vStatusComment := '';

      v_nCount := 0;
      dtSys := sysdate;
      v_currpwd := '';

      pck_fx_sec.ValidatePassword(pi_vKey,
                                  pi_nFXUserID,
                                  pi_vUserName,
                                  'NA',
                                  pi_vPassword,
                                  'NA',
                                  pi_vCPassword,
                                  pi_vCUserName,
                                  1,
                                  po_nStatusCode,
                                  po_vStatusComment);
      if po_nStatusCode != 0 then
         return;
      end if;
                        
      --update date_password_changed if the user changed the pwd
      v_vSql := 'select password from tbicds.fx_user where fx_user_id = :P0';
      execute immediate v_vSql into v_currpwd using pi_nFXUserID;
      
      if v_currpwd != pi_vPassword then
         v_vSql := 'update tbicds.fx_user set '
                   || 'date_password_changed = :P0, '
                   || 'last_updated = sysdate, '
                   || 'last_updated_by = :P1 '
                   || 'where fx_user_id = :P2 ';
         execute immediate v_vSql using dtSys, pi_nUserID, pi_nFXUserID;
         commit;
      end if;

      v_vSql := 'update tbicds.fx_user set '
                || 'is_locked = :P0, '
                || 'is_inactive = :P1, '
                || 'date_modified = :P2, '
                || 'updated_by = :P3, '
                || 'reset_password = 1, ' --always MUST CHANGE PASSWORD
                || 'password = :P4, '
                || 'last_updated = sysdate, '
                || 'last_updated_by = :P5 '
                || 'where fx_user_id = :P6 ';
      execute immediate v_vSql using pi_nAccountLocked, pi_nAccountInactive, dtSys, pi_nUserID, pi_vPassword, pi_nUserID, pi_nFXUserID;
      commit;

   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := '178 - An error occurred while updating a patients password, Please contact your system administrator.';
   end;

   /* updates the patient portal account options */
   procedure UpdatePatientFXUserOptions(pi_vSessionID              in varchar2,
                                        pi_vSessionClientIP        in varchar2,
                                        pi_nUserID                 in number,
                                        pi_nFXUserID               in number,
                                        pi_nAccountLocked          in number,
                                        pi_nAccountInactive        in number,
                                        po_nStatusCode             out number,
                                        po_vStatusComment          out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nCount            number;
      dtSys               date;
   begin
      --default status to good
      po_nStatusCode := 0; --0 = success
      po_vStatusComment := '';

      dtSys := sysdate;

      v_vSql := 'update tbicds.fx_user set '
                || 'is_locked = :P0, '
                || 'is_inactive = :P1, '
                || 'date_modified = :P2, '
                || 'updated_by = :P3, '
                || 'last_updated = sysdate, '
                || 'last_updated_by = :P4 '
                || 'where fx_user_id = :P5 ';
      execute immediate v_vSql using pi_nAccountLocked, pi_nAccountInactive, dtSys, pi_nUserID, pi_nUserID, pi_nFXUserID;
      commit;
      
      -- when the account is re-activated, reset the answer attempts number in fx_sec_question
      if pi_nAccountLocked = 0 then
         v_vSql := ' update tbicds.fx_sec_questions t set '
                   || 't.answer_attempts = 0, '
                   || 't.last_updated = sysdate '
                   || 'where t.fx_user_id = :P0 ';
         execute immediate v_vSql using pi_nFXUserID;
         commit;
      end if;

   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := '179 - An error occurred while updating a patients user account, Please contact your system administrator.';
   end;
 

end;
/

